<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description"
    content="Value-added services from MK Trading Company including bulk supply, technical consultation, logistics, and after-sales support.">
  <link rel="icon" type="image/png" sizes="16x16" href="asset/images/mk logo1.png">
    <title>Services - MK Trading Company</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="assets/css/style.css">
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
  <style>
    /* Custom AOS animation to match requirements: opacity 0.2 initially */
    [data-aos] {
      opacity: 0.2;
      transform: translateY(20px);
      transition-property: opacity, transform;
      transition-duration: 600ms;
      transition-timing-function: ease-out;
    }

    [data-aos].aos-animate {
      opacity: 1;
      transform: translateY(0);
    }
  </style>
</head>

<body>
  <!-- Navigation -->
    <?php
include 'nav.php';?>

  <!-- Page Header -->
  <section class="page-header services-page-header" id="services-page-header">
    <div class="container">
      <h1 data-aos="fade-up">Beyond Products: Our Value-Added Services</h1>
    </div>
  </section>

  <!-- Services Section -->
  <section class="content-section services-content-section" id="services-content-section">
    <div class="container">
      <p class="text-min" style="text-align: center; font-size: 1.1rem; margin-bottom: 3rem;" data-aos="fade-up">At MK
        Trading Company, we go beyond
        just supplying products. We offer comprehensive services designed to support your projects from start to
        finish, ensuring your complete satisfaction.</p>

      <div class="feature-grid">
        <div class="feature-item" data-aos="fade-up" data-aos-delay="0">
          <div class="stat-icon" style="font-size: 3rem; margin-bottom: 1rem;" data-aos="fade-up" data-aos-delay="50">📦
          </div>
          <h3 data-aos="fade-up" data-aos-delay="100">Bulk Supply & Sourcing</h3>
          <p data-aos="fade-up" data-aos-delay="150">Reliable and timely supply for large-scale projects. We understand
            the critical importance of
            meeting deadlines and maintaining consistent quality. Our bulk supply services ensure you have
            everything you need when you need it, with competitive pricing for volume orders.</p>
        </div>
        <div class="feature-item" data-aos="fade-up" data-aos-delay="200">
          <div class="stat-icon" style="font-size: 3rem; margin-bottom: 1rem;" data-aos="fade-up" data-aos-delay="250">
            💡</div>
          <h3 data-aos="fade-up" data-aos-delay="300">Technical Consultation</h3>
          <p data-aos="fade-up" data-aos-delay="350">Expert advice on product selection and application. Our experienced
            team provides personalized
            recommendations based on your specific requirements, budget, and project goals. We help you make
            informed decisions that ensure optimal results.</p>
        </div>
        <!-- <div class="feature-item">
                    <div class="stat-icon" style="font-size: 3rem; margin-bottom: 1rem;">🚚</div>
                    <h3>Logistics & Delivery</h3>
                    <p>Efficient and safe delivery network. We have established logistics partnerships that enable us to
                        deliver products safely and on time, anywhere in the country. Our delivery services are designed
                        to minimize damage and ensure your products arrive in perfect condition.</p>
                </div> -->
        <div class="feature-item" data-aos="fade-up" data-aos-delay="400">
          <div class="stat-icon" style="font-size: 3rem; margin-bottom: 1rem;" data-aos="fade-up" data-aos-delay="450">
            🤝</div>
          <h3 data-aos="fade-up" data-aos-delay="500">After-Sales Support</h3>
          <p data-aos="fade-up" data-aos-delay="550">Dedicated support to ensure customer satisfaction. Our commitment
            doesn't end with the sale. We
            provide comprehensive after-sales support, including product guidance, troubleshooting
            assistance, and warranty services to ensure your complete satisfaction.</p>
        </div>
      </div>

      <!-- <div style="text-align: center; margin-top: 3rem;">
                <a href="contact.html" class="btn btn-primary">Contact Us for Services</a>
            </div> -->
    </div>
  </section>

<?php include 'footer.php';?>