<?php
session_start();
include 'db.html';

$message = "";

if (!isset($_SESSION['reset_email'])) {
    header("Location: forgot_password.html");
    exit();
}

$email = $_SESSION['reset_email'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $newPassword = password_hash($_POST['password'], PASSWORD_BCRYPT);

    $stmt = $conn->prepare("UPDATE admin SET password = ? WHERE email = ?");
    $stmt->bind_param("ss", $newPassword, $email);
    $stmt->execute();

    unset($_SESSION['reset_email']);
    $message = "<div class='alert alert-success text-center'>Password has been reset successfully! <a href='login.html' class='text-decoration-none'>Login here</a>.</div>";
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Reset Password - MK Trading</title>

  <link href="asset/images/mk logo1.png" rel="icon">
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link
    href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap"
    rel="stylesheet">

  <link href="scss/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="scss/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="scss/css/main.css" rel="stylesheet">

  <style>
    body {
      background-color: #f4f6f8;
      font-family: 'Poppins', sans-serif;
    }

    .login-card {
      width: 400px;
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
      padding: 2rem;
    }

    .login-card h3 {
      font-weight: 600;
      color: #0060b1;
    }

    .login-logo {
      text-align: center;
      margin-bottom: 1rem;
    }

    .login-logo img {
      max-height: 80px;
    }

    .password-toggle {
      position: absolute;
      right: 15px;
      top: 38px;
      cursor: pointer;
      color: #888;
    }
  </style>
</head>

<body class="d-flex align-items-center justify-content-center vh-100">

  <div class="login-card">
    <div class="login-logo">
      <img src="asset/images/mk logo1.png" alt="Iatrike Biogenics">
    </div>
    <h3 class="text-center mb-3">Reset Password</h3>

    <?= $message ?>
    <?php if (!$message): ?>
    <form method="POST">
      <div class="mb-3 position-relative">
        <label class="form-label">New Password</label>
        <input type="password" id="password" name="password" class="form-control" required placeholder="Enter new password">
        <i class="bi bi-eye-slash password-toggle" id="togglePassword"></i>
      </div>
      <button type="submit" class="btn btn-primary w-100">Update Password</button>
    </form>
    <?php endif; ?>
  </div>

  <script>
    const togglePassword = document.querySelector("#togglePassword");
    const passwordInput = document.querySelector("#password");

    togglePassword.addEventListener("click", function() {
      const type = passwordInput.getAttribute("type") === "password" ? "text" : "password";
      passwordInput.setAttribute("type", type);
      this.classList.toggle("bi-eye");
      this.classList.toggle("bi-eye-slash");
    });
  </script>

  <script src="scss/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
