<?php
include 'db.php';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Discover exclusive offers and special promotions from MK Trading Company. Limited time deals on quality products.">
    <link rel="icon" type="image/png" sizes="16x16" href="asset/images/mk logo1.png">
    <title>Special Offers - MK Trading Company</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />

    <style>
        /* AOS animation */
        [data-aos] {
            opacity: 0.2;
            transform: translateY(20px);
            transition-property: opacity, transform;
            transition-duration: 600ms;
            transition-timing-function: ease-out;
        }

        [data-aos].aos-animate {
            opacity: 1;
            transform: translateY(0);
        }
    </style>
</head>

<body>

<?php include 'nav.php'; ?>

<!-- Hero Section -->
<section class="page-header offers-hero">
    <div class="container">
        <h1 data-aos="fade-up">MK Trading Company Special Offers</h1>
        <p data-aos="fade-up" data-aos-delay="50">Discover our latest deals and exclusive promotions on quality products</p>
    </div>
</section>

<!-- Offers Section -->
<section class="offers-section">
    <div class="container">
        <div class="offers-grid">

            <?php
            $offers = $conn->query("SELECT * FROM offers ORDER BY id DESC");
            $delay = 0;

            if ($offers->num_rows > 0):
                while ($offer = $offers->fetch_assoc()):
                    
                    $media = "assets/images/" . $offer['media'];
                    $isVideo = preg_match('/\.(mp4|mov|avi)$/i', $offer['media']);
            ?>

            <div class="offer-card" data-aos="fade-up" data-aos-delay="<?= $delay ?>">
                <div class="offer-media">

                    <?php if ($isVideo): ?>
                        <div class="offer-video" data-aos="fade-up" data-aos-delay="<?= $delay + 50 ?>">
                            <video controls class="offer-video-player">
                                <source src="<?= $media ?>" type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                        </div>

                    <?php else: ?>
                        <a href="#" class="offer-image-link">
                            <img src="<?= $media ?>"
                                 alt="<?= htmlspecialchars($offer['title']) ?>"
                                 onerror="this.src='assets/images/default.jpg'; this.onerror=null;"
                                 data-aos="fade-up"
                                 data-aos-delay="<?= $delay + 50 ?>">
                        </a>
                    <?php endif; ?>

                </div>

                <div class="offer-content">
                    <h3 class="offer-title" data-aos="fade-up" data-aos-delay="<?= $delay + 100 ?>">
                        <?= htmlspecialchars($offer['title']) ?>
                    </h3>

                    <p class="offer-description" data-aos="fade-up" data-aos-delay="<?= $delay + 150 ?>">
                        <?= nl2br(htmlspecialchars($offer['description'])) ?>
                    </p>

                    <div class="offer-meta" data-aos="fade-up" data-aos-delay="<?= $delay + 200 ?>">
                        <span class="offer-validity" data-aos="fade-up" data-aos-delay="<?= $delay + 250 ?>">
                            <strong>Valid Until:</strong>
                            <?= date("F d, Y", strtotime($offer['valid_until'])) ?>
                        </span>
                    </div>
                </div>
            </div>

            <?php 
                $delay += 100; 
                endwhile;
            else:
            ?>

            <p class="no-offers" style="text-align:center; font-size:20px; padding:30px;">
                No offers available at the moment.
            </p>

            <?php endif; ?>

        </div>
    </div>
</section>

<?php include 'footer.php'; ?>

