<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description"
    content="MK Trading Company - Your Premier Partner in Hardware & Building Solutions. Quality hardware, sanitary ware, tiles, electricals, and more." />
    <link rel="icon" type="image/png" sizes="16x16" href="asset/images/mk logo1.png">
  <title>
    MK Trading Company - Quality Hardware Solutions for Every Project
  </title>
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap"
    rel="stylesheet" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
  <style>
    /* Custom AOS animation to match requirements: opacity 0.2 initially */
    [data-aos] {
      opacity: 0.2;
      transform: translateY(20px);
      transition-property: opacity, transform;
      transition-duration: 600ms;
      transition-timing-function: ease-out;
    }

    [data-aos].aos-animate {
      opacity: 1;
      transform: translateY(0);
    }
  </style>
  <link rel="preload" as="image" href="assets/images/bg1.jpeg" />
  <link rel="preload" as="image" href="assets/images/bg2.jpeg" />
  <link rel="preload" as="image" href="assets/images/bg3.jpeg" />
  <link rel="preload" as="image" href="assets/images/bg4.jpeg" />
</head>

<body>
  
<?php include 'nav.php';?>
  <!-- Hero Section -->
  <section class="hero">
    <div class="hero-bg-slider">
      <div class="hero-bg-slider-track">
        <div class="hero-bg-slide">
          <img src="assets/images/bg1.jpeg" alt="Background 1" loading="eager" fetchpriority="high" />
        </div>
        <div class="hero-bg-slide">
          <img src="assets/images/bg7.jpeg.jpg" alt="Background 2" loading="lazy" />
        </div>
        <div class="hero-bg-slide">
          <img src="assets/images/bg8.jpeg.jpg" alt="Background 3" loading="lazy" />
        </div>
        <div class="hero-bg-slide">
          <img src="assets/images/bg4.jpeg" alt="Background 4" loading="lazy" />
        </div>
      </div>
    </div>
    <div class="hero-overlay"></div>
    <div class="hero-content">
      <h1 data-aos="fade-up">Quality Hardware Solutions for Every Project</h1>
      <p data-aos="fade-up" data-aos-delay="100">
        From household DIY to industrial construction, we supply the finest
        sanitary ware, tiles, electricals, tools, and more.
      </p>
      <div class="hero-slider">
        <div class="slider-wrapper">
          <div class="slider-track">
            <div class="slider-card">
              <img src="assets/images/slr1.jpeg" alt="Image 1" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr2.jpeg" alt="Image 2" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr13.jpeg" alt="Image 3" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr4.jpeg" alt="Image 4" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr5.jpeg" alt="Image 5" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr14.jpg" alt="Image 6" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr15.jpg" alt="Image 7" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr8.jpeg" alt="Image 8" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr9.jpeg" alt="Image 9" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr10.jpeg" alt="Image 10" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr11.jpeg" alt="Image 11" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr12.jpeg" alt="Image 12" />
            </div>
            <!-- Duplicate set for seamless loop -->
            <div class="slider-card">
              <img src="assets/images/slr1.jpeg" alt="Image 1" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr2.jpeg" alt="Image 2" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr13.jpeg" alt="Image 3" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr4.jpeg" alt="Image 4" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr5.jpeg" alt="Image 5" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr6.jpeg" alt="Image 6" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr7.jpeg" alt="Image 7" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr8.jpeg" alt="Image 8" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr9.jpeg" alt="Image 9" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr10.jpeg" alt="Image 10" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr11.jpeg" alt="Image 11" />
            </div>
            <div class="slider-card">
              <img src="assets/images/slr12.jpeg" alt="Image 12" />
            </div>
          </div>
        </div>
      </div>
      <div class="hero-buttons" data-aos="fade-up" data-aos-delay="200">
        <a href="sectors.html" class="btn btn-primary">Explore Our Products</a>
        <!-- <a href="contact.html" class="btn btn-secondary">Contact Us Today</a> -->
      </div>
    </div>
  </section>

  <!-- Introduction Section -->
  <section class="intro-section">
    <canvas id="confetti-canvas"></canvas>
    <div class="container">
      <h2 data-aos="fade-up">Welcome to MK Trading Company</h2>
      <p data-aos="fade-up" data-aos-delay="100">
        For over two decades, MK Trading Company has been a trusted name in
        the hardware and building supplies industry. We pride ourselves on our
        vast inventory, competitive pricing, and unwavering commitment to
        customer satisfaction. Our expertise spans across residential,
        commercial, and industrial sectors.
      </p>
    </div>
  </section>

  <!-- Key Stats -->
  <section class="stats-section">
    <div class="container">
      <div class="stats-grid">
        <div class="stat-item" data-aos="fade-up" data-aos-delay="0">
          <div class="stat-icon" data-aos="fade-up" data-aos-delay="50">📅</div>
          <h3 data-aos="fade-up" data-aos-delay="100">15+</h3>
          <p data-aos="fade-up" data-aos-delay="150">Years of Experience</p>
        </div>
        <div class="stat-item" data-aos="fade-up" data-aos-delay="100">
          <div class="stat-icon" data-aos="fade-up" data-aos-delay="150">📦</div>
          <h3 data-aos="fade-up" data-aos-delay="200">5000+</h3>
          <p data-aos="fade-up" data-aos-delay="250">Products</p>
        </div>
        <div class="stat-item" data-aos="fade-up" data-aos-delay="200">
          <div class="stat-icon" data-aos="fade-up" data-aos-delay="250">👥</div>
          <h3 data-aos="fade-up" data-aos-delay="300">100000+</h3>
          <p data-aos="fade-up" data-aos-delay="350">Happy Clients</p>
        </div>
        <div class="stat-item" data-aos="fade-up" data-aos-delay="300">
          <div class="stat-icon" data-aos="fade-up" data-aos-delay="350">🚚</div>
          <h3 data-aos="fade-up" data-aos-delay="400">All Karnataka & Kerala</h3>
          <p data-aos="fade-up" data-aos-delay="450">Delivery</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Featured Sectors -->
  <section class="featured-sectors">
    <div class="container">
      <h2 data-aos="fade-up">Our Key Sectors</h2>
      <div class="sectors-grid">
        <a href="products.php?sector_id=11" class="sector-card" data-aos="fade-up" data-aos-delay="0">
          <div class="sector-icon">
            <img src="assets/images/tiles.jpeg" alt="Tiles" data-aos="fade-up" data-aos-delay="50" />
          </div>
          <h3 data-aos="fade-up" data-aos-delay="100">Tiles</h3>
          <p data-aos="fade-up" data-aos-delay="150">Marble, Kitchen, Terrace, Bathroom Tiles</p>
        </a>
        <a href="products.php?sector_id=13" class="sector-card" data-aos="fade-up" data-aos-delay="100">
          <div class="sector-icon">
            <img src="assets/images/sec-sanitary.jpeg.jpg" alt="Sanitary Ware" data-aos="fade-up" data-aos-delay="150" />
          </div>
          <h3 data-aos="fade-up" data-aos-delay="200">Sanitary Ware</h3>
          <p data-aos="fade-up" data-aos-delay="250">Basins, Water Closets, Showers</p>
        </a>
        <a href="products.php?sector_id=10" class="sector-card" data-aos="fade-up" data-aos-delay="200">
          <div class="sector-icon">
            <img src="assets/images/sec-electrical.jpeg.jpg" alt="Electricals" data-aos="fade-up" data-aos-delay="250" />
          </div>
          <h3 data-aos="fade-up" data-aos-delay="300">Electricals</h3>
          <p data-aos="fade-up" data-aos-delay="350">Switches, Sockets, Fans, Sensors</p>
        </a>
        <a href="products.php?sector_id=9" class="sector-card" data-aos="fade-up" data-aos-delay="300">
          <div class="sector-icon">
            <img src="assets/images/plumbing.jpeg" alt="Plumbing" data-aos="fade-up" data-aos-delay="350" />
          </div>
          <h3 data-aos="fade-up" data-aos-delay="400">Plumbing</h3>
          <p data-aos="fade-up" data-aos-delay="450">Pipes, Fittings, Tanks, Valves</p>
        </a>
        <a href="products.php?sector_id=8" class="sector-card" data-aos="fade-up" data-aos-delay="400">
          <div class="sector-icon">
            <img src="assets/images/sec-hardware.jpeg.jpg" alt="Hardware Tools" data-aos="fade-up" data-aos-delay="450" />
          </div>
          <h3 data-aos="fade-up" data-aos-delay="500">Hardware Tools</h3>
          <p data-aos="fade-up" data-aos-delay="550">Power Tools, Hand Tools, Tool Kits</p>
        </a>
      </div>
    </div>
  </section>

 <?php 
$brands = $conn->query("SELECT * FROM brands ORDER BY id DESC");
?>

<section class="brands-section">
  <div class="container">
    <div class="brands-wrapper">

      <div class="brands-content">
        <span class="brands-tagline" data-aos="fade-up">Our Brands</span>
        <h2 class="brands-title" data-aos="fade-up" data-aos-delay="50">Trusted by leaders</h2>
        <p class="brands-subtitle" data-aos="fade-up" data-aos-delay="100">from various industries</p>
        <p class="brands-description" data-aos="fade-up" data-aos-delay="150">
          Learn why professionals trust our solutions to complete their customer journeys.
        </p>
      </div>

      <!-- Responsive grid -->
      <div class="brands-grid">

        <?php
        $delay = 0;

        while ($b = $brands->fetch_assoc()) { ?>
        
          <div class="brand-logo" data-aos="fade-up" data-aos-delay="<?= $delay ?>">
            <img src="assets/images/<?= $b['image'] ?>" 
                 alt="<?= htmlspecialchars($b['title']) ?>">
          </div>

        <?php 
          $delay += 50;
        } 
        ?>

      </div>

    </div>
  </div>
</section>



  <!-- CTA Banner -->
  <section class="cta-banner">
    <div class="container">
      <div class="cta-content">
        <h2 data-aos="fade-up">Can't find what you're looking for?</h2>
        <p data-aos="fade-up" data-aos-delay="50">Our experts are here to help.</p>
        <div class="dropdown cta-dropdown" style="display: inline-block" data-aos="fade-up" data-aos-delay="100">
          <a href="#contact-branch" class="btn btn-primary dropdown-toggle">CONTACT US <span class="arrow">▼</span></a>
          <ul class="dropdown-menu">
            <li>
              <a href="#" class="branch-option-contact" data-branch="branch1">Cherkala</a>
            </li>
            <li>
              <a href="#" class="branch-option-contact" data-branch="branch2">Ishwaramangala</a>
            </li>
          </ul>
        </div>
      </div>  
    </div>
  </section>

 

<?php
include 'db.php';

$reviews = $conn->query("SELECT * FROM reviews ORDER BY id DESC");
?>

<!-- Testimonials Section -->
<section class="testimonials-section">
  <div class="container">
    <div class="testimonials-wrapper">
      
      <div class="testimonials-left">
        <h2 class="testimonials-title" data-aos="fade-up">Testimonial</h2>
        <div class="testimonials-tagline">
          <p data-aos="fade-up" data-aos-delay="50">What our customers say about us</p>
        </div>
      </div>

      <div class="testimonials-right">
        <div class="testimonials-carousel">

          <?php 
          $delay = 0;
          while ($row = $reviews->fetch_assoc()): 
          ?>

          <div class="testimonial-card" data-index="<?= $row['id'] ?>" data-aos="fade-up" data-aos-delay="<?= $delay ?>">
            <div class="testimonial-header">

              <div class="testimonial-name-box">
                <h3 class="testimonial-name" data-aos="fade-up" data-aos-delay="<?= $delay + 50 ?>">
                  <?= htmlspecialchars($row['title']) ?>
                </h3>
              </div>

              <div class="testimonial-photo">
                <img 
                  src="assets/images/<?= $row['image'] ?>" 
                  alt="<?= htmlspecialchars($row['title']) ?>" 
                  data-aos="fade-up" 
                  data-aos-delay="<?= $delay + 100 ?>"
                >
              </div>

            </div>

            <div class="testimonial-review-box">
              <p class="testimonial-review" data-aos="fade-up" data-aos-delay="<?= $delay + 150 ?>">
                "<?= htmlspecialchars($row['description']) ?>"
              </p>
            </div>
          </div>

          <?php 
          $delay += 100;
          endwhile; 
          ?>

        </div>
      </div>

    </div>
  </div>
</section>

 

<?php include 'footer.php';?>