<?php
include 'db.php'; // database connection
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description"
        content="Explore our gallery showcasing MK Trading Company's products, applications, warehouse, and client projects.">
    <link rel="icon" type="image/png" sizes="16x16" href="asset/images/mk logo1.png">
        <title>Gallery - MK Trading Company</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />

    <style>
        [data-aos] {
            opacity: 0.2;
            transform: translateY(20px);
            transition: opacity 600ms ease-out, transform 600ms ease-out;
        }

        [data-aos].aos-animate {
            opacity: 1;
            transform: translateY(0);
        }
    </style>
</head>

<body>

    <!-- Navigation -->
    <?php include 'nav.php'; ?>

    <!-- Page Header -->
    <section class="page-header gallery-page-header" id="gallery-page-header">
        <div class="container">
            <h1 data-aos="fade-up">A Glimpse of Our World</h1>
        </div>
    </section>

    <!-- Gallery Section -->
    <section class="content-section gallery-content-section" id="gallery-content-section">
        <div class="container">

            <!-- Gallery Filters -->
            <div class="gallery-filters">
                <button class="filter-btn active" data-filter="all" data-aos="fade-up">All</button>
                <button class="filter-btn" data-filter="product" data-aos="fade-up" data-aos-delay="50">Product Showcase</button>
                <button class="filter-btn" data-filter="projects" data-aos="fade-up" data-aos-delay="100">Client Projects</button>
            </div>

            <!-- Gallery Grid -->
            <div class="gallery-grid">
                <?php
                $gallery = $conn->query("SELECT * FROM gallery ORDER BY id DESC");
                $delay = 0;

                while ($row = $gallery->fetch_assoc()):
                    $delay += 100;
                ?>
                    <div class="gallery-item <?= $row['category']; ?>" data-aos="fade-up" data-aos-delay="<?= $delay; ?>">
                        <img src="assets/images/<?= $row['image']; ?>" alt="<?= htmlspecialchars($row['title']); ?>">
                        <div class="caption"><?= htmlspecialchars($row['title']); ?></div>
                    </div>
                <?php endwhile; ?>
            </div>

        </div>
    </section>

    <!-- Footer -->
    <?php include 'footer.php'; ?>

