<?php
session_start();
include 'db.html';

$message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email']);

    $stmt = $conn->prepare("SELECT * FROM admin WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $_SESSION['reset_email'] = $email;
        header("Location: reset_password.html");
        exit();
    } else {
        $message = "No admin found with that email address.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Forgot Password - MK Trading</title>

  <link href="asset/images/mk logo1.png" rel="icon">
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link
    href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap"
    rel="stylesheet">

  <link href="scss/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
  <link href="scss/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
  <link href="scss/css/main.css" rel="stylesheet">

  <style>
    body {
      background-color: #f4f6f8;
      font-family: 'Poppins', sans-serif;
    }

    .login-card {
      width: 400px;
      background: #fff;
      border-radius: 12px;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
      padding: 2rem;
    }

    .login-card h3 {
      font-weight: 600;
      color: #0060b1;
    }

    .login-logo {
      text-align: center;
      margin-bottom: 1rem;
    }

    .login-logo img {
      max-height: 80px;
    }
  </style>
</head>

<body class="d-flex align-items-center justify-content-center vh-100">

  <div class="login-card">
    <div class="login-logo">
      <img src="asset/images/mk logo1.png" alt="Iatrike Biogenics">
    </div>
    <h3 class="text-center mb-3">Forgot Password</h3>

    <?php if ($message): ?>
      <div class="alert alert-danger text-center"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="POST">
      <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" required placeholder="Enter your registered email">
      </div>
      <button type="submit" class="btn btn-primary w-100 mb-3">Continue</button>

      <div class="text-center">
        <a href="login.html" class="text-decoration-none">Back to Login</a>
      </div>
    </form>
  </div>

  <script src="scss/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
