<?php
include 'db.php'; // Database connection
include 'nav.php';

date_default_timezone_set('Asia/Kolkata');

// Initialize variables
$errors = ['name'=>'','email'=>'','phone'=>'','message'=>'','form'=>''];
$success = '';
$name = $email = $phone = $message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name    = trim($_POST['name']);
    $email   = trim($_POST['email']);
    $phone   = trim($_POST['phone']);
    $message = trim($_POST['message']);
    $submitted_at = date('Y-m-d H:i:s');

    // Validation (same as job application)
    if(empty($name)) 
        $errors['name'] = "Name is required.";

    if(empty($email)) 
        $errors['email'] = "Email is required.";
    elseif(!filter_var($email, FILTER_VALIDATE_EMAIL)) 
        $errors['email'] = "Invalid email address.";

    if(empty($phone)) 
        $errors['phone'] = "Phone number is required.";
    elseif(!preg_match('/^\d{10}$/', $phone)) 
        $errors['phone'] = "Phone must be exactly 10 digits.";

    if(empty($message)) 
        $errors['message'] = "Message is required.";

    // If no validation errors
    if(!array_filter($errors)) {

        $stmt = $conn->prepare("INSERT INTO contact(name,email,phone,message,created_at) VALUES(?,?,?,?,?)");

        if(!$stmt) {
            $errors['form'] = "Database prepare failed: " . $conn->error;
        } else {
            $stmt->bind_param("sssss", $name, $email, $phone, $message, $submitted_at);

            if($stmt->execute()) {
                $success = "✅ Thank you, your message has been saved successfully!";
                $name = $email = $phone = $message = ''; // Clear fields
            } else {
                $errors['form'] = "Database execute failed: " . $stmt->error;
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Contact Us - MK Trading Company</title>
<link rel="stylesheet" href="assets/css/style.css">
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
<style>
    [data-aos]{opacity:0.2;transform:translateY(20px);transition: opacity 600ms ease-out, transform 600ms ease-out;}
    [data-aos].aos-animate{opacity:1;transform:translateY(0);}
    .error-message{color:red;font-size:0.9em;}
    .success-message{color:green;font-size:1em;margin-bottom:10px;}
</style>
</head>
<body>

<section class="contact-section" id="contact-branch">
    <div class="contact-header">
        <div class="contact-header-bg"></div>
        <div class="container">
            <h1 data-aos="fade-up">Contact Us</h1>
        </div>
    </div>

    <div class="contact-main">
        <div class="container">
            <div class="contact-wrapper">
                <div class="contact-form-panel">
                    <div class="contact-form-header">
                        <p data-aos="fade-up">Contact Us</p>
                        <h2 data-aos="fade-up" data-aos-delay="50">Get In Touch</h2>
                    </div>

                    <?php if($success): ?>
                        <p class="success-message"><?php echo $success; ?></p>
                    <?php endif; ?>

                    <?php if($errors['form']): ?>
                        <p class="error-message"><?php echo $errors['form']; ?></p>
                    <?php endif; ?>

                    <form class="contact-form" method="POST" action="" novalidate>

                        <div class="form-group" data-aos="fade-up" data-aos-delay="100">
                            <label for="contact-name">Name <span class="required">*</span></label>
                            <input type="text" id="contact-name" name="name" placeholder="Your Name"
                                   class="<?php echo $errors['name'] ? 'input-error' : ''; ?>"
                                   value="<?php echo htmlspecialchars($name); ?>" />
                            <span class="error-message"><?php echo $errors['name']; ?></span>
                        </div>

                        <div class="form-group" data-aos="fade-up" data-aos-delay="200">
                            <label for="contact-email">Email <span class="required">*</span></label>
                            <input type="email" id="contact-email" name="email" placeholder="example@yourmail.com"
                                   class="<?php echo $errors['email'] ? 'input-error' : ''; ?>"
                                   value="<?php echo htmlspecialchars($email); ?>" />
                            <span class="error-message"><?php echo $errors['email']; ?></span>
                        </div>

                        <div class="form-group" data-aos="fade-up" data-aos-delay="300">
                            <label for="contact-phone">Phone Number <span class="required">*</span></label>
                            <input type="tel" id="contact-phone" name="phone" placeholder="9876543210"
                                   class="<?php echo $errors['phone'] ? 'input-error' : ''; ?>"
                                   value="<?php echo htmlspecialchars($phone); ?>" />
                            <span class="error-message"><?php echo $errors['phone']; ?></span>
                        </div>

                        <div class="form-group" data-aos="fade-up" data-aos-delay="400">
                            <label for="contact-message">Message <span class="required">*</span></label>
                            <textarea id="contact-message" name="message" placeholder="Type Here..."
                                      class="<?php echo $errors['message'] ? 'input-error' : ''; ?>"><?php echo htmlspecialchars($message); ?></textarea>
                            <span class="error-message"><?php echo $errors['message']; ?></span>
                        </div>

                        <button type="submit" class="btn-send" data-aos="fade-up" data-aos-delay="500">Send Now</button>
                    </form>
                </div>
<div class="contact-info-panel">
            <p class="contact-intro" data-aos="fade-up">
             At MK Trading, we value every customer and inquiry. Whether you need assistance choosing the right tiles and sanitary ware, want product details, or have a general question, our team is ready to support you.
Feel free to reach out through phone, email, WhatsApp, or visit our office—we’re committed to providing quick and reliable service.
            </p>
            <div class="contact-methods">
              <div class="contact-method" data-aos="fade-up" data-aos-delay="0">
                <div class="contact-icon" data-aos="fade-up" data-aos-delay="50">📞</div>
                <div class="contact-details">
                  <h4 data-aos="fade-up" data-aos-delay="100">Phone Number</h4>
                  <p data-aos="fade-up" data-aos-delay="150">+6282 4032 567</p>
                </div>
              </div>
              <div class="contact-method" data-aos="fade-up" data-aos-delay="100">
                <div class="contact-icon" data-aos="fade-up" data-aos-delay="150">✉️</div>
                <div class="contact-details">
                  <h4 data-aos="fade-up" data-aos-delay="200">Email Address</h4>
                  <p data-aos="fade-up" data-aos-delay="250">Example@Email.Com</p>
                </div>
              </div>
              <div class="contact-method" data-aos="fade-up" data-aos-delay="200">
                <div class="contact-icon" data-aos="fade-up" data-aos-delay="250">💬</div>
                <div class="contact-details">
                  <h4 data-aos="fade-up" data-aos-delay="300">Whatsapp</h4>
                  <p data-aos="fade-up" data-aos-delay="350">+91 98095 15845</p>
                </div>
              </div>
              <div class="contact-method" data-aos="fade-up" data-aos-delay="300">
                <div class="contact-icon" data-aos="fade-up" data-aos-delay="350">📍</div>
                <div class="contact-details">
                  <h4 data-aos="fade-up" data-aos-delay="400">Our Office</h4>
                  <p data-aos="fade-up" data-aos-delay="450">Chengala, Kundadukkam, Thearkada, Chengala-671541</p>
                </div>
              </div>
            </div>
            <div class="contact-map">
              <div class="branch-map" data-branch="branch1">
                <iframe
                  src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d7790.19903687927!2d75.05356307358235!3d12.509562354541147!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ba48388a30a0d4b%3A0x1ae0c1b870e119cb!2sMK%20Trading%20Co.!5e0!3m2!1sen!2sin!4v1763637626799!5m2!1sen!2sin"
                  width="400" height="300" style="border: 0" allowfullscreen="" loading="lazy"
                  referrerpolicy="no-referrer-when-downgrade"></iframe>
              </div>
              <div class="branch-map" data-branch="branch2" style="display: none">
                <iframe
                  src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3893.41174757942!2d75.25133957483511!3d12.620971487663166!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3ba493c50fd5b4bb%3A0xa87f9e210772a81a!2sMK%20trading%20company!5e0!3m2!1sen!2sin!4v1763635556044!5m2!1sen!2sin"
                  width="400" height="300" style="border: 0" allowfullscreen="" loading="lazy"
                  referrerpolicy="no-referrer-when-downgrade"></iframe>
              </div>
            </div>
          </div>
            </div>
        </div>
    </div>
</section>

<?php include 'footer.php'; ?>
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
<script>
  AOS.init();
</script>
</body>
</html>
