<?php
include 'db.php';
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta name="description"
    content="Learn about MK Trading Company - Our story, mission, vision, and why we're the trusted choice for hardware and building solutions." />
  <link rel="icon" type="image/png" sizes="16x16" href="asset/images/mk logo1.png">
    <title>Career Listing - MK Trading Company</title>
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap"
    rel="stylesheet" />
  <link rel="stylesheet" href="assets/css/style.css" />
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />
  <style>
    /* Custom AOS animation to match requirements: opacity 0.2 initially */
    [data-aos] {
      opacity: 0.2;
      transform: translateY(20px);
      transition-property: opacity, transform;
      transition-duration: 600ms;
      transition-timing-function: ease-out;
    }
    [data-aos].aos-animate {
      opacity: 1;
      transform: translateY(0);
    }
  </style>
</head>

<body>

<?php include 'nav.php'; ?>

<section class="page-header careers-page-header">
    <div class="container">
        <h1>Build Your Career with MK Trading</h1>
    </div>
</section>

<section class="content-section careers-content-section">
    <div class="container">
        <p class="text-min" style="text-align: center; font-size: 1.1rem; margin-bottom: 3rem;" data-aos="fade-up">We are
        always looking
        for passionate
        and driven individuals to join our growing team. Explore opportunities to grow professionally in a
        dynamic environment where your contributions make a real difference.</p>


        <h2>Current Openings</h2>

        <?php
        $jobs = $conn->query("SELECT * FROM careers ORDER BY id DESC");

        if ($jobs->num_rows > 0):
            while ($job = $jobs->fetch_assoc()):
        ?>
                <div class="job-listing" data-aos="fade-up" style="margin-bottom: 40px;">

              <h3><?= htmlspecialchars($job['title']) ?></h3>

              <div class="job-meta">
                  <span><strong>Location:</strong> <?= htmlspecialchars($job['location']) ?></span>
                  <span><strong>Experience:</strong> <?= htmlspecialchars($job['experience']) ?></span>
                  <span><strong>Department:</strong> <?= htmlspecialchars($job['department']) ?></span>

                 
              </div>

              <p style="margin-top:10px;">
                <?= nl2br(htmlspecialchars($job['description'])) ?>
              </p>

              <a href="job-application.php?job_id=<?= $job['id'] ?>" class="btn btn-primary">
                  Apply Now
              </a>

          </div>

        <?php 
            endwhile;
        else:
        ?>

            <p>No job openings available right now.</p>

        <?php endif; ?>

    </div>
</section>

<?php include 'footer.php'; ?>
</body>
</html>
