<?php
include 'auth.php';
include 'db.php';
include 'adminhead.php';
include 'sidebar.php';

$success = "";
$error = "";

/* -------------------------
   DELETE JOB
---------------------------*/
if (isset($_GET['delete_id'])) {
    $id = intval($_GET['delete_id']);

    $stmt = $conn->prepare("DELETE FROM careers WHERE id=?");
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        $success = "Job deleted successfully!";
    } else {
        $error = "Failed to delete job: " . $stmt->error;
    }
}

/* -------------------------
   ADD JOB
---------------------------*/
if (isset($_POST['add_job'])) {
    $title       = $_POST['title'];
    $location    = $_POST['location'];
    $experience  = $_POST['experience'];
    $salary      = $_POST['salary'];
    $department  = $_POST['department'];
    $description = $_POST['description'];

    $stmt = $conn->prepare("
        INSERT INTO careers (title, location, experience, salary, department, description, created_at)
        VALUES (?, ?, ?, ?, ?, ?, NOW())
    ");
    $stmt->bind_param("ssssss", $title, $location, $experience, $salary, $department, $description);

    $success = $stmt->execute() ? "Job added successfully!" : "Failed to add job: " . $stmt->error;
}

/* -------------------------
   UPDATE JOB
---------------------------*/
if (isset($_POST['update_job'])) {
    $id          = intval($_POST['id']);
    $title       = $_POST['title'];
    $location    = $_POST['location'];
    $experience  = $_POST['experience'];
    $salary      = $_POST['salary'];
    $department  = $_POST['department'];
    $description = $_POST['description'];

    $stmt = $conn->prepare("
        UPDATE careers 
        SET title=?, location=?, experience=?, salary=?, department=?, description=? 
        WHERE id=?
    ");
    $stmt->bind_param("ssssssi", $title, $location, $experience, $salary, $department, $description, $id);

    $success = $stmt->execute() ? "Job updated successfully!" : "Failed to update job: " . $stmt->error;
}

/* -------------------------
   FETCH JOB LIST
---------------------------*/
$data = $conn->query("SELECT * FROM careers ORDER BY id DESC");
?>

<div class="page-wrapper">
    <div class="container-fluid">

        <h3 class="mb-4 fw-bold">Manage Careers</h3>

        <?php if ($success): ?>
            <div class="alert alert-success"><?= $success ?></div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>

        <!-- ADD JOB FORM -->
        <div class="card mb-4">
            <div class="card-header">Add New Job Opening</div>
            <div class="card-body">
                <form method="POST">
                    <div class="row">

                        <div class="col-md-6 mb-3">
                            <label>Job Title</label>
                            <input type="text" name="title" class="form-control" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Location</label>
                            <input type="text" name="location" class="form-control" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Experience</label>
                            <input type="text" name="experience" class="form-control" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Salary (Optional)</label>
                            <input type="text" name="salary" class="form-control">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Department</label>
                            <input type="text" name="department" class="form-control" required>
                        </div>

                        <div class="col-md-12 mb-3">
                            <label>Description</label>
                            <textarea name="description" class="form-control" rows="3" required></textarea>
                        </div>

                    </div>
                    <button type="submit" name="add_job" class="btn btn-primary">Add Job</button>
                </form>
            </div>
        </div>

        <!-- JOB LIST TABLE -->
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="bg-dark text-white">
                    <tr>
                        <th>#</th>
                        <th>Job Title</th>
                        <th>Location</th>
                        <th>Experience</th>
                        <th>Salary</th>
                        <th>Department</th>
                        <th>Description</th>
                        <th>Posted On</th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $i=1; while($row = $data->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['title']) ?></td>
                        <td><?= htmlspecialchars($row['location']) ?></td>
                        <td><?= htmlspecialchars($row['experience']) ?></td>
                        <td><?= htmlspecialchars($row['salary'] ?: "Not Mentioned") ?></td>
                        <td><?= htmlspecialchars($row['department']) ?></td>
                        <td><?= htmlspecialchars(substr($row['description'], 0, 50)) ?>...</td>
                        <td><?= $row['created_at'] ?></td>

                        <td>
                            <button class="btn btn-warning btn-sm" data-toggle="modal"
                                data-target="#edit<?= $row['id'] ?>">Edit</button>

                            <a href="?delete_id=<?= $row['id'] ?>"
                               onclick="return confirm('Delete this job?')"
                               class="btn btn-danger btn-sm">
                               Delete
                            </a>
                        </td>
                    </tr>

                    <!-- EDIT JOB MODAL -->
                    <div class="modal fade" id="edit<?= $row['id'] ?>" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <form method="POST">

                                    <div class="modal-header">
                                        <h5>Edit Job #<?= $row['id'] ?></h5>
                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                    </div>

                                    <div class="modal-body">

                                        <input type="hidden" name="id" value="<?= $row['id'] ?>">

                                        <div class="form-group">
                                            <label>Job Title</label>
                                            <input type="text" class="form-control" name="title"
                                                   value="<?= htmlspecialchars($row['title']) ?>" required>
                                        </div>

                                        <div class="form-group">
                                            <label>Location</label>
                                            <input type="text" class="form-control" name="location"
                                                   value="<?= htmlspecialchars($row['location']) ?>" required>
                                        </div>

                                        <div class="form-group">
                                            <label>Experience</label>
                                            <input type="text" class="form-control" name="experience"
                                                   value="<?= htmlspecialchars($row['experience']) ?>" required>
                                        </div>

                                        <div class="form-group">
                                            <label>Salary</label>
                                            <input type="text" class="form-control" name="salary"
                                                   value="<?= htmlspecialchars($row['salary']) ?>">
                                        </div>

                                        <div class="form-group">
                                            <label>Department</label>
                                            <input type="text" class="form-control" name="department"
                                                   value="<?= htmlspecialchars($row['department']) ?>" required>
                                        </div>

                                        <div class="form-group">
                                            <label>Description</label>
                                            <textarea class="form-control" name="description" rows="3"
                                                      required><?= htmlspecialchars($row['description']) ?></textarea>
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <button type="submit" name="update_job" class="btn btn-success">Save</button>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>

                    <?php endwhile; ?>
                </tbody>

            </table>
        </div>

    </div>
</div>

<?php include 'adminfoot.php'; ?>
